# Download macOS arm64 build from GitHub Actions
# Update $RunId with the workflow run number from GitHub Actions

$Owner = "MiBaDK"
$Repo = "video-manager"
$RunId = "22442075090"  # Update this to the new workflow run ID

$ScriptDir = Split-Path -Parent $MyInvocation.MyCommand.Path
$ProjectDir = Split-Path -Parent $ScriptDir
$OutputDir = Join-Path $ProjectDir "dist"

if (-not (Test-Path $OutputDir)) {
    New-Item -ItemType Directory -Path $OutputDir | Out-Null
}

Write-Host "Downloading macOS arm64 build..."
Write-Host "Output dir: $OutputDir"

$Token = (gh auth token)

$Headers = @{
    "Authorization" = "Bearer $Token"
    "Accept" = "application/vnd.github+json"
}

$ArtifactsUrl = "https://api.github.com/repos/$Owner/$Repo/actions/runs/$RunId/artifacts"
$Artifacts = Invoke-RestMethod -Uri $ArtifactsUrl -Headers $Headers
$Artifact = $Artifacts.artifacts | Where-Object { $_.name -eq "MiBa-Video-Manager" }

if ($Artifact) {
    Write-Host "Found artifact, downloading..."
    $OutputFile = Join-Path $OutputDir "MiBa-Video-Manager.zip"
    $DownloadHeaders = @{
        "Authorization" = "Bearer $Token"
        "Accept" = "application/vnd.github+json"
    }
    Invoke-WebRequest -Uri $Artifact.archive_download_url -Headers $DownloadHeaders -OutFile $OutputFile -UseBasicParsing
    Write-Host "Done! Downloaded to: $OutputFile"
} else {
    Write-Host "Artifact not found. Check the RunId."
}
